Test_TouchMap = class()

function Test_TouchMap:init()
    self.title = "touchMap functions"
    self.hasCustomControls = true 
end

function Test_TouchMap:setup()
    self.unit = WIDTH * 0.04  
    self.lab = PhysicsLab()
    --make ground and random circles
    self.lab:makePetrieDish()
    for i = 1, 7 do
        local randomX = math.random(math.floor(WIDTH*0.2), math.floor(WIDTH*0.4))
        local randomY = math.random(math.floor(HEIGHT*0.2), math.floor(HEIGHT*0.4))
        local circle = self.lab:circleAt(randomX, randomY, math.random(math.floor(self.unit * 2.6 ), math.floor(self.unit * 3)))
    end
    --make three touchMap functions
    --the first is the existing one
    local normal = self.lab.touchMapFunctions[1]
    --the second gives a burst of random upwards velocity to a tapped circle
    local spinner = function(touchMap)
        local mapCount = 0
        for k,v in pairs(touchMap) do
            mapCount = mapCount + 1
            v.body.angularVelocity = 1000
        end
        if mapCount == 0 then
            for _, body in ipairs(self.lab.bodies) do
                body.angularVelocity = 0
            end
        end
    end
    --the third makes a kooky jittery orbit around your finger
    local jitterer = function(touchMap)
        local velocityLimit = 1000
        for k,v in pairs(touchMap) do
            local offsetX = math.random(math.floor(self.unit * -0.5), math.floor(self.unit * 0.5))
            local offsetY = math.random(math.floor(self.unit * -0.5), math.floor(self.unit * 0.5))
            v.body.position = vec2(v.tp.x + offsetX, v.tp.y + offsetY)
        end
    end
    --make a table with those functions
    local functions = { normal, spinner, jitterer }
    
    --make an integer slider control that switches between functions
    parameter.integer("touchMapFunction", 1, 4, 1, function(value)
            self.lab.touchMapFunctions = { functions[value] }
        if value == 4 then
            self.lab.touchMapFunctions = { normal, spinner }
        end
    end)
    
    print("PhysicsLab helps you manage dragging and multiple touches with touchMap functions. These can be added, swapped, or combined at will.\n\nTry the different settings to see different functions in action.")
end

function Test_TouchMap:draw()
    self.lab:draw()
    if touchMapFunction == 1 then
        self.title = "touchMap functions (current: normal dragging)"
    elseif touchMapFunction == 2 then
        self.title = "touchMap functions (current: press causes spin)"
    elseif touchMapFunction == 3 then
        self.title = "touchMap functions (current: jittery motion around touch)"
    elseif touchMapFunction == 4 then
        self.title = "touchMap functions (current: both dragging and spin)"
    end 
end

function Test_TouchMap:touched(touch)
    self.lab:touched(touch)
end

function Test_TouchMap:collide(contact)
    self.lab:collide(contact)
end

function Test_TouchMap:cleanup()
    self.lab:clear()
end
